# 画面設計書 17-Streaming Query Statistics（ストリーミングクエリ統計）

## 概要

本ドキュメントは、Apache Spark Application UIのStructured Streamingタブにあるストリーミングクエリ統計画面の設計内容を記述する。本画面は特定ストリーミングクエリの入力レート・処理レート・バッチ期間等の統計情報をタイムライン・ヒストグラムグラフで表示する。

### 本画面の処理概要

**業務上の目的・背景**：Spark Structured Streamingのリアルタイム処理において、クエリのパフォーマンスを継続的に監視することは安定運用の要である。本画面により、運用者はInput Rate（入力レート）、Process Rate（処理レート）、Input Rows（入力行数）、Batch Duration（バッチ処理時間）、Operation Duration（操作別処理時間）の各メトリクスをタイムライングラフとヒストグラムで視覚的に確認できる。また、State Store関連のメトリクス（状態行数・メモリ使用量・ウォーターマーク情報等）やカスタムメトリクスも表示可能であり、ステートフル処理の健全性を包括的に監視できる。

**画面へのアクセス方法**：ストリーミングクエリ一覧画面（No.16）のRun IDリンクをクリックすることでアクセスする。URLパラメータとしてid（Run ID）が必要。

**主要な操作・処理内容**：
1. 基本情報（稼働時間、開始日時、完了バッチ数、Name、ID、RunID）を確認する
2. Input Rate/Process Rate/Input Rows/Batch Durationのタイムライン・ヒストグラムを確認する
3. Operation Duration のスタック面グラフで操作別処理時間の内訳を確認する
4. Global Watermark Gapの推移を確認する（ウォーターマーク使用時）
5. Aggregated State Operatorメトリクス（Total/Updated/Removed State Rows, Memory Used, Late Rows Dropped）を確認する
6. カスタムメトリクス（StateStoreProvider固有のメトリクス）を確認する

**画面遷移**：ストリーミングクエリ一覧画面（No.16）からRun IDリンク経由で遷移する。本画面からの遷移先はない。

**権限による表示制御**：ACL設定が有効な場合、閲覧権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 17 | Spark Web UI | 主機能 | 特定ストリーミングクエリの入力レート・処理レート・バッチ期間等をグラフ表示する主処理 |
| 36 | ストリーム処理エンジン | 主機能 | マイクロバッチの実行統計（Input Rows/Batch Duration/Operation Duration）を取得してD3.jsグラフ表示 |
| 38 | ステート管理 | 補助機能 | State Store関連のカスタムメトリクス（state rows等）を取得して表示 |
| 39 | チェックポイント管理 | 補助機能 | チェックポイント関連のメトリクス（Offset commit duration等）を表示 |

## 画面種別

詳細（統計ダッシュボード）

## URL/ルーティング

- パス: `/StreamingQuery/statistics/`
- パラメータ: `id` (必須) - ストリーミングクエリのRun ID
- 例: `/StreamingQuery/statistics/?id=abc-def-123`

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|------|------|------|
| id | 入力（URLパラメータ） | String（UUID） | 必須 | ストリーミングクエリのRun ID |

## 表示項目

### 基本情報セクション

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| Running Duration | String | 稼働時間（人間可読形式） |
| Start Time | Date | クエリ開始日時 |
| Completed Batches | Long | 完了バッチ数 |
| Name | String | クエリ名 |
| Id | UUID | クエリID |
| RunId | UUID | 実行ランID |

### 統計テーブル（タイムライン + ヒストグラム）

| メトリクス名 | 単位 | 説明 |
|-------------|------|------|
| Input Rate | records/sec | 入力レート（全ソース集約） |
| Process Rate | records/sec | 処理レート（全ソース集約） |
| Input Rows | records | 入力行数 |
| Batch Duration | ms | バッチ処理時間 |
| Operation Duration | ms | 操作別処理時間（スタック面グラフ。triggerExecutionを除く） |
| Global Watermark Gap | seconds | ウォーターマークギャップ（ウォーターマーク使用時のみ） |
| Aggregated Number Of Total State Rows | records | 全State Operator合計のState行数 |
| Aggregated Number Of Updated State Rows | records | 更新されたState行数 |
| Aggregated Number Of Removed State Rows | records | 削除されたState行数 |
| Aggregated State Memory Used In Bytes | bytes | State Storeメモリ使用量 |
| Aggregated Number Of Late Rows Dropped By Watermark | records | ウォーターマークにより棄却された遅延行数 |
| Aggregated Custom Metric {name} | - | カスタムメトリクス（設定で有効化されたもの） |

## イベント仕様

### 1-タイムライングラフのホバー

タイムライングラフ上にマウスをホバーすると、該当バッチの詳細情報（バッチID、時刻、メトリクス値）がツールチップで表示される。

### 2-ヒストグラムグラフ

各メトリクスのヒストグラムがタイムラインの右側に表示される。メトリクス値の分布を確認できる。

### 3-Operation Duration スタック面グラフ

操作別の処理時間をスタック面グラフで表示する。addBatch、getBatch、commitOffsets等の各操作の時間配分を視覚化する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ページ表示 | - | SELECT | StreamingQueryStatusStore.allQueryUIDataからRun IDで対象クエリを検索 |

本画面はデータベースへの更新操作を行わない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| MSG-001 | エラー | "Missing id parameter" | idパラメータが未指定の場合 |
| MSG-002 | エラー | "Failed to find streaming query {parameterId}" | 指定Run IDのクエリが見つからない場合 |
| MSG-003 | 情報 | "No visualization information available." | 進捗データがない場合 |

## 例外処理

- idパラメータ未指定: require文でエラー
- 指定Run IDのクエリなし: IllegalArgumentExceptionがスローされる
- 進捗データなし: "No visualization information available."メッセージが表示される

## 備考

- D3.js（d3.min.js）を使用してタイムライン・ヒストグラム・面グラフを描画
- streaming-page.css、streaming-page.js、structured-streaming-page.jsの静的リソースを使用
- Operation DurationからtriggerExecutionを除外する（他の操作時間を含むため二重カウント防止）
- カスタムメトリクスはStateStoreProviderのsupportedCustomMetricsと、spark.sql.streaming.ui.enabledCustomMetricList設定の両方で有効化されたもののみ表示
- ウォーターマークギャップは(batchTimestamp - watermarkValue) / 1000.0で秒単位に変換
- GraphUIDataクラスを使用してタイムライン・ヒストグラムHTMLを生成し、JsCollectorでJavaScriptコードを集約

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | StreamingQueryUIData | `sql/core/src/main/scala/org/apache/spark/sql/streaming/ui/StreamingQueryUIData.scala` | summary、recentProgress、lastProgressフィールドを確認。recentProgressはArray[StreamingQueryProgress] |
| 1-2 | StreamingQueryProgress | Spark SQLライブラリ | inputRowsPerSecond, processedRowsPerSecond, numInputRows, batchDuration, durationMs, stateOperators, eventTimeフィールドを確認 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | StreamingQueryStatisticsPage.scala | `sql/core/src/main/scala/org/apache/spark/sql/streaming/ui/StreamingQueryStatisticsPage.scala` | 行37-38: WebUIPage("statistics")でURLパスを設定 |

**主要処理フロー**:
1. **行60-61**: パラメータID取得とrequireチェック
2. **行63-65**: parent.store.allQueryUIDataからRun IDで検索
3. **行67-73**: リソース読み込み + 基本情報 + 統計テーブル生成
4. **行114-144**: generateBasicInfoで基本情報HTML生成
5. **行390-564**: generateStatTableでメトリクスグラフ群を生成

#### Step 3: グラフ生成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | StreamingQueryStatisticsPage.scala | `sql/core/src/main/scala/org/apache/spark/sql/streaming/ui/StreamingQueryStatisticsPage.scala` | 行390-564: generateStatTableメソッド。各メトリクスのGraphUIDataを生成し、テーブルに配置 |
| 3-2 | StreamingQueryStatisticsPage.scala | `sql/core/src/main/scala/org/apache/spark/sql/streaming/ui/StreamingQueryStatisticsPage.scala` | 行146-196: generateWatermarkメソッド。ウォーターマークギャップの計算とグラフ生成 |
| 3-3 | StreamingQueryStatisticsPage.scala | `sql/core/src/main/scala/org/apache/spark/sql/streaming/ui/StreamingQueryStatisticsPage.scala` | 行198-343: generateAggregatedStateOperatorsメソッド。State Operator集約メトリクスのグラフ生成 |
| 3-4 | GraphUIData | `core/src/main/scala/org/apache/spark/ui/GraphUIData.scala` | タイムライン・ヒストグラムHTML/JS生成の汎用クラス |

### プログラム呼び出し階層図

```
StreamingQueryTab [行23]
    |
    +-- StreamingQueryStatisticsPage (WebUIPage("statistics")) [行32]
            |
            +-- render(request) [行59]
                    |
                    +-- parent.store.allQueryUIData.find() [行63-65]
                    |
                    +-- generateLoadResources(request) [行67]
                    |
                    +-- generateBasicInfo(query) [行68]
                    |
                    +-- generateStatTable(query, request) [行72]
                            |
                            +-- GraphUIData (Input Rate) [行434-443]
                            +-- GraphUIData (Process Rate) [行446-455]
                            +-- GraphUIData (Input Rows) [行458-467]
                            +-- GraphUIData (Batch Duration) [行470-479]
                            +-- GraphUIData (Operation Duration) [行482-491]
                            +-- generateWatermark() [行548]
                            +-- generateAggregatedStateOperators() [行549]
                                    |
                                    +-- generateAggregatedCustomMetrics() [行337]
```

### データフロー図

```
[入力]                          [処理]                              [出力]

id (Run ID) ─────────────> StreamingQueryStatisticsPage.render()
(URLパラメータ)                    |
                                   +---> StreamingQueryStatusStore
                                   |     .allQueryUIData.find()
                                   |           |
                                   |     StreamingQueryUIData <──
                                   |           |
                                   +---> generateBasicInfo() ──────> 基本情報HTML
                                   |
                                   +---> generateStatTable() ──────> 統計グラフHTML
                                   |     (GraphUIData x N)           (タイムライン+ヒストグラム)
                                   |           |
                                   |     +---> generateWatermark() ──> ウォーターマークグラフ
                                   |     +---> generateAggregatedStateOperators()
                                   |     |     ──> State Operatorグラフ群
                                   |     +---> generateAggregatedCustomMetrics()
                                   |           ──> カスタムメトリクスグラフ
                                   |
                                   +---> headerSparkPage() ────────> 完成ページHTML
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| StreamingQueryStatisticsPage.scala | `sql/core/src/main/scala/org/apache/spark/sql/streaming/ui/StreamingQueryStatisticsPage.scala` | ソース | メイン画面ページクラス |
| StreamingQueryTab.scala | `sql/core/src/main/scala/org/apache/spark/sql/streaming/ui/StreamingQueryTab.scala` | ソース | タブ定義 |
| StreamingQueryUIData.scala | `sql/core/src/main/scala/org/apache/spark/sql/streaming/ui/StreamingQueryUIData.scala` | ソース | クエリUIデータモデル |
| UIUtils.scala (streaming) | `sql/core/src/main/scala/org/apache/spark/sql/streaming/ui/UIUtils.scala` | ソース | Streaming固有UIユーティリティ |
| GraphUIData.scala | `core/src/main/scala/org/apache/spark/ui/GraphUIData.scala` | ソース | タイムライン・ヒストグラム汎用クラス |
| JsCollector.scala | `core/src/main/scala/org/apache/spark/ui/JsCollector.scala` | ソース | JavaScript集約ユーティリティ |
| d3.min.js | `core/src/main/resources/org/apache/spark/ui/static/d3.min.js` | JavaScript | D3.jsライブラリ |
| streaming-page.css | `core/src/main/resources/org/apache/spark/ui/static/streaming-page.css` | CSS | ストリーミングページスタイル |
| streaming-page.js | `core/src/main/resources/org/apache/spark/ui/static/streaming-page.js` | JavaScript | ストリーミングページ共通ロジック |
| structured-streaming-page.js | `core/src/main/resources/org/apache/spark/ui/static/structured-streaming-page.js` | JavaScript | Structured Streaming固有ロジック |
